/*
 * Decompiled with CFR 0.152.
 */
package common.control;

import common.util.Tools;
import java.util.Stack;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public final class DisplayManager {
    private static final DisplayManager instance = new DisplayManager();
    private Display display = null;
    private final Stack stack = new Stack();

    private DisplayManager() {
    }

    public static DisplayManager getInstance() {
        return instance;
    }

    public synchronized void init(Display display) {
        this.display = display;
    }

    public synchronized void push(Displayable displayable) {
        this.stack.push(displayable);
        this.display.setCurrent(displayable);
        Tools.getInstance().triggerGarbageCollection();
    }

    public synchronized void push(Alert alert) {
        if (!this.stack.empty()) {
            Displayable displayable = (Displayable)this.stack.peek();
            this.display.setCurrent(alert, displayable);
            Tools.getInstance().triggerGarbageCollection();
        }
    }

    public synchronized void pop() {
        if (!this.stack.empty()) {
            Displayable displayable = (Displayable)this.stack.peek();
            this.stack.pop();
            if (!this.stack.empty()) {
                displayable = (Displayable)this.stack.peek();
                this.display.setCurrent(displayable);
            }
            Tools.getInstance().triggerGarbageCollection();
        }
    }

    public synchronized void pop(Alert alert) {
        if (!this.stack.empty()) {
            if (alert != null) {
                this.stack.pop();
                this.push(alert);
            } else {
                this.pop();
            }
        }
    }
}

